clear all;
%neuron fluoresce (max fluorescence)
lambda_i=500; 
%baseline fluoresce (backround noise)
lambda_o=100; 

%parameters for MCMC sampling
maxmarkovcounter= 1e4; %set number of iterations
intervalP=250; %number of proposals between samples
burnin=.5e4; %number of proposals to discard before saving samples
slideshow_start=0 %number of proposals to wait before starting slideshow
%also, note that MCMC runs much more quickly without displaying images

%parameters which determine penalty strength
alpha1= 0;% for number of edges of edge-set pixels
alpha2= 0;% for number of elements in the edge set

%parameters for searching for the best threshold of the poisson data after convolution
thresholdNo=6; %number of different thresholds to take
startmult= .6; %fraction of the mean to start the search for optimal thresholds
endmult= 1.4; %fraction of the mean to end search for optimal threshold

%parameters related to the point spread function (we use a gaussian)
psf_spread= 2*.04; %the spread of the gaussian
psf_size= 3; %determines the diameter of the gaussian: diameter = 2*psfsize+1

disp('input parameters are defined')


%some sample values for inputs:
%from "Bayesian Image Recovery for Dendritic
%Structures Under Low Signal-to-Noise Conditions"
%figure 6 uses:
%row1-- lamba_i=500, lambda_o=250, maxmarkovcounter=2e4, intervalP=200,
%burnin= .5e4, alpha1=0, alpha2=0, all other values the same as defined above
%row2-- lamba_i=500, lambda_o=100, all other values as in row 1
%row3-- lamba_i=500, lambda_o=1, all other values as in row 1
%figure 7 uses:
%row1-- lamba_i=500, lambda_o=250, maxmarkovcounter=2e4, intervalP=200,
%burnin= .5e4, alpha1=.2, alpha2=2, all other values the same as defined above
%row2-- lamba_i=500, lambda_o=100, all other values as in row 1
%row2-- lamba_i=500, lambda_o=1, all other values as in row 1
%
% note: lamba_o should reasonably range from 1 to lamba_i


